from datetime import datetime
import json
from jose import jwt
from hashlib import md5
import requests

from dotenv import load_dotenv
import os

load_dotenv()

api_key = os.environ.get("API_KEY")

# api_key = '<<SUA API KEY>>'

def create_encoded_header(endpoint, body, method):
    client_private_key = '''-----BEGIN EC PRIVATE KEY-----
    <<SUA PRIVATE KEY>>
    -----END EC PRIVATE KEY-----'''

    today_str = datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S")

    dict_to_sign = {"timestamp": today_str, "method": method, "uri": endpoint}

    body_bytes = json.dumps(body).encode()

    md5_instance = md5()
    md5_instance.update(body_bytes)
    md5_body = md5_instance.hexdigest()


    dict_to_sign["payload_md5"] = md5_body

    jwt_headers = {"alg": "ES512", "typ": "JWT"}
    encoded_header_token = jwt.encode(
        claims=dict_to_sign,
        key=client_private_key,
        algorithm="ES512",
        headers=jwt_headers,
    )
    return encoded_header_token

FUND_CLASS_KEY = ''
ASSIGNMENT_CONFIGURATION_KEY = ''
BASE_URL = f'fund_class/{FUND_CLASS_KEY}/assignment_configuration/{ASSIGNMENT_CONFIGURATION_KEY}'
EXTERNAL_ID = ''

base_url = "https://manager-api.sandbox.qidtvm.com.br"
endpoint = f" /settlement/fund_class/{FUND_CLASS_KEY}/payment_batch/{EXTERNAL_ID}/settlement"
method = "POST"

body = {
    "asset_type": "ccb", 
    "total_value": 130.50,
    "external_id": "13d20e94-e1c6-4c9d-a398-83f84d1f9b92",
    "settlement_type": "installment_settlement",
    "installment_number": 1,
    "collection_date": "2025-01-01"
}

encoded_header_token = create_encoded_header(endpoint, body, method=method)

headers = {"API-CLIENT-KEY": api_key, "AUTHORIZATION": encoded_header_token}

url = f"{base_url}{endpoint}"

resp = requests.post(url=url, headers=headers, json=body)
print(resp.json())
